// components/btPeripheral/btPeripheral.js
Component({
  /**
   * 组件的属性列表
   */
  properties: {

  },

  /**
   * 组件的初始数据
   */
  data: {
    deviceList: [], // 設備名稱清單
    currentIndex: 0,
    selectedDevice: '', // 選擇的項目
  },

  /**
   * 组件的方法列表
   */
  methods: {
    btScan: async function () {
      const sdk = getApp().globalData.sdk;
      const list = (await sdk.btScan()) || [];
      this.setData({
        deviceList: list,
        currentIndex:0,
        selectedDevice: list[0]
      }) //存入目前data區資料 應該也會像React的setStates() 進行頁面刷新
      console.log('sdk.btScan()', this.data.deviceList);
      console.log('Selected device:', list[0]);
    },
    deviceChooseHandler: function (e) {
      const deviceName = this.data.deviceList[e.detail.current];
      this.setData({
        currentIndex: e.detail.current,
        selectedDevice: deviceName
      });
      console.log('Selected device:', deviceName);
    },
    deviceOpen: async function () {
      const sdk = getApp().globalData.sdk;
      const openDevice = this.data.selectedDevice;
      console.log(`k debug: into deviceOpen(${openDevice}) function`)
      let res = await sdk.deviceOpen(openDevice);
      console.log('sdk.deviceOpen() ', res);
    },
    deviceClose: async function () {
      const sdk = getApp().globalData.sdk;
      let res = await sdk.deviceClose();
      console.log('sdk.deviceClose() ', res);
      this.setData({
        deviceList:[]
      })
    }



  }
})
